import React, { useState } from "react";
import dialogues from "./dialogues";
import stringSimilarity from "string-similarity";

function App() {
  const [theme, setTheme] = useState("");
  const [index, setIndex] = useState(0);
  const [reponse, setReponse] = useState("");
  const [historique, setHistorique] = useState([]);
  const [enCours, setEnCours] = useState(false);

  const themesDisponibles = Object.keys(dialogues);

  const handleThemeChange = (event) => {
    setTheme(event.target.value);
    setIndex(0);
    setReponse("");
    setHistorique([]);
  };

  const currentQuestions = theme ? dialogues[theme].questions : [];
  const currentReponses = theme ? dialogues[theme].reponses : [];
  const questionActuelle = currentQuestions[index];
  const bonneReponse = currentReponses[index] || "";

  const SpeechRecognition = window.SpeechRecognition || window.webkitSpeechRecognition;

  const demarrerReconnaissance = () => {
    if (!SpeechRecognition) {
      alert("La reconnaissance vocale n'est pas supportée par ce navigateur. Essaie avec Google Chrome.");
      return;
    }

    const recognition = new SpeechRecognition();
    recognition.lang = "de-DE";
    recognition.interimResults = false;
    recognition.maxAlternatives = 1;

    recognition.onstart = () => setEnCours(true);
    recognition.onend = () => setEnCours(false);
    recognition.onerror = (e) => {
      console.error("Erreur :", e.error);
      alert("Erreur de reconnaissance vocale.");
    };

    recognition.onresult = (event) => {
      const texte = event.results[0][0].transcript;
      setReponse(texte);
    };

    recognition.start();
  };

  const correctionAutomatique = () => {
    const score = stringSimilarity.compareTwoStrings(
      reponse.toLowerCase(),
      bonneReponse.toLowerCase()
    );
    return score >= 0.6;
  };

  const scoreSimilarite = () => {
    return (
      stringSimilarity.compareTwoStrings(
        reponse.toLowerCase(),
        bonneReponse.toLowerCase()
      ) * 100
    ).toFixed(0);
  };

  const enregistrerReponse = () => {
    setHistorique([
      ...historique,
      {
        question: questionActuelle,
        reponse: reponse,
        correct: correctionAutomatique(),
      },
    ]);
    setReponse("");
    setIndex((prev) => (prev + 1) % currentQuestions.length);
  };

  return (
    <div style={{ padding: "2rem", fontFamily: "Arial" }}>
      <h1>🎓 Dialogtraining A2</h1>

      <label>
        🎯 Wähle ein Thema: &nbsp;
        <select value={theme} onChange={handleThemeChange}>
          <option value="">-- Thema wählen --</option>
          {themesDisponibles.map((t, i) => (
            <option key={i} value={t}>{t}</option>
          ))}
        </select>
      </label>

      {theme && (
        <div style={{ marginTop: "2rem" }}>
          <h2><strong>Frage {index + 1}:</strong> {questionActuelle}</h2>

          <button onClick={demarrerReconnaissance} disabled={enCours}>
            🎤 Antwort sprechen
          </button>

          <p><strong>Deine Antwort:</strong> {reponse}</p>

          {reponse && (
            <div>
              <p style={{ color: correctionAutomatique() ? "green" : "red" }}>
                <strong>Correction :</strong> {correctionAutomatique() ? "✅ Bonne réponse !" : "❌ Ce n’est pas encore ça..."}
              </p>
              <p>🎯 Similarité : {scoreSimilarite()}%</p>
              {!correctionAutomatique() && (
                <p>👉 Réponse attendue : <em>{bonneReponse}</em></p>
              )}
            </div>
          )}

          <button onClick={enregistrerReponse} disabled={!reponse}>
            💾 Enregistrer & ➡️ Suivante
          </button>

          <h3>📜 Historique des réponses :</h3>
          <ul>
            {historique.map((item, i) => (
              <li key={i}>
                <strong>{item.question}</strong><br />
                ➡️ {item.reponse} {item.correct ? "✅" : "❌"}
              </li>
            ))}
          </ul>
        </div>
      )}
    </div>
  );
}

export default App;
